package com.image.scale;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

import java.nio.file.Files;
import java.nio.file.Path;

import com.grapecity.documents.excel.*;
import com.grapecity.documents.excel.drawing.*;

public class App {
  public static void main(String[] args) {
	  try {
		  insertImageToExcel();
		  getImageDimensions();
		  openFile("file.xlsx");
	  }
	  catch(IOException ex) {
		  System.out.println(ex.getMessage());
	  }
  }
  
  private static void insertImageToExcel() throws IOException {
	    Workbook workbook = new Workbook();
	    IWorksheet worksheet = workbook.getWorksheets().get(0);
	    IShape shape = worksheet.getShapes().addPictureInPixel(
	        Files.newInputStream(Path.of("image.svg")),
	        ImageType.SVG,
	        9.0,
	        9.0,
	        800,
	        800
	    );
	    shape.setPlacement(Placement.FreeFloating);
	    
	    workbook.save("file.xlsx", SaveFileFormat.Xlsx);
	}
  
  private static void getImageDimensions() {
	    Workbook book = new Workbook();
	    book.open("file.xlsx");
	    IWorksheet sheet = book.getWorksheets().get(0);
	    IShape sh = sheet.getShapes().get(0);
	    System.out.println("Width in Pixels : " + sh.getWidthInPixel());
	    System.out.println("Height in Pixels : " + sh.getHeightInPixel());
  }

  private static void openFile(String filePath) {
	  File file = new File(filePath);
      try {
          if (Desktop.isDesktopSupported()) {
              Desktop desktop = Desktop.getDesktop();
              if (file.exists()) {
                  desktop.open(file);
              } else {
                  System.err.println("File does not exist: " + file.getAbsolutePath());
              }
          } else {
              System.err.println("Desktop is not supported.");
          }
      } catch (IOException e) {
          e.printStackTrace();
          System.err.println("Error opening file: " + e.getMessage());
      }
  }
}
